/**********
* File: CDGL_IDirect3DStateBlock9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DStateBlock9. 
					 This class is the concrete implementation of IDirect3DStateBlock9 interface. The IDirect3DStateBlock9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 18Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DSTATEBLOCK9_H__
#define __CDGL_IDIRECT3DSTATEBLOCK9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

class CDGL_IDirect3DStateBlock9 : public IDirect3DStateBlock9
{
	public: 
	
		CDGL_IDirect3DStateBlock9(IDirect3DDevice9* in_pDevice);
		~CDGL_IDirect3DStateBlock9();
		
		/*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DStateBlock9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT Capture();
		HRESULT Apply();

			
	
	private:
		//! Member Variables
		IDirect3DDevice9 *		m_pDevice;
		int						m_lRefCount;


};

#endif //__CDGL_IDIRECT3DSTATEBLOCK9_H__

